/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemCartridgePart;
import frc.emul.config.data.IUnique;
import frc.util.IStream;
import frc.util.IStreamFactory;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CfgItemBankMenu
implements IUnique {
    public String id;
    public String name;
    public String path;
    public Mode mode;
    public int banksCounterSize;
    public int banksNamesSize;
    public boolean isDefault;

    @Override
    public String getID() {
        return this.id;
    }

    public boolean hasContent() {
        return CfgItemCartridge.isNotBlank(this.path);
    }

    IStream generateContent(List<CfgItemCartridgePart> list) {
        IStream iStream = IStreamFactory.create(this.path);
        int n = list.size();
        byte[] byArray = new byte[this.banksCounterSize + n * this.banksNamesSize];
        int n2 = 0;
        Arrays.fill(byArray, (byte)32);
        if (this.banksCounterSize > 2) {
            byArray[n2++] = (byte)(n >> 16);
        }
        if (this.banksCounterSize > 1) {
            byArray[n2++] = (byte)(n >> 8);
        }
        if (this.banksCounterSize > 0) {
            byArray[n2++] = (byte)n;
        }
        int n3 = 0;
        while (n3 < n) {
            byte[] byArray2;
            String string = list.get((int)n3).label;
            if (string == null || string.trim().length() == 0) {
                string = "BANK " + (n3 + 1);
            }
            try {
                byArray2 = list.get((int)n3).label.trim().toUpperCase().getBytes("ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray2 = list.get((int)n3).label.trim().toUpperCase().getBytes();
            }
            System.arraycopy(byArray2, 0, byArray, n2, Math.min(this.banksNamesSize, byArray2.length));
            n2 += this.banksNamesSize;
            ++n3;
        }
        return IStreamFactory.compose("BANK 0", iStream, IStreamFactory.create("Menu Data", byArray));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        VECFLASH("VECFLASH"),
        VECMULTI("VECMULTI");

        private final String key;

        private Mode(String string2) {
            this.key = string2;
        }

        public String getKey() {
            return this.key;
        }

        public static Mode getMode(String string) {
            Mode[] modeArray = Mode.values();
            int n = modeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mode mode = modeArray[n2];
                if (mode.key.equalsIgnoreCase(string)) {
                    return mode;
                }
                ++n2;
            }
            return null;
        }
    }
}

